go 

IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_TELE_ORC_REMOVE_ALERTA')
begin
	DROP TRIGGER [dbo].[TRG_TELE_ORC_REMOVE_ALERTA]
end
go

-- RECRIA


--05 entreges
--06 cancelados
--10 devolvido
--12 pedido pesquisa

CREATE TRIGGER [dbo].[TRG_TELE_ORC_REMOVE_ALERTA] ON [dbo].[TELE_ORC_ETAPA] FOR 
INSERT AS
begin

	begin try
	
		-- VERIFICA SE ESTA ALTERANDO PEDIDO PESQUISA
		DECLARE @CD_ORC INT
		DECLARE @ETAPA INT
		DECLARE @ETAPA_IN INT
		SELECT @CD_ORC = CD_ORC, @ETAPA_IN = CD_ETAPAS FROM INSERTED
		SET @ETAPA = (SELECT TOP 1 CD_ETAPAS FROM TELE_ORC_ETAPA WHERE CD_ORC = @CD_ORC ORDER BY CD_ORC_ETAPA DESC)
		-- ALTERANDO SOMENTE PEDIDO QUE SOFRAM ALTERACOES
		IF @ETAPA = 7 AND @ETAPA_IN <> 12
			BEGIN
				DELETE FROM TELE_ORC_ALERTA WHERE CD_ORC = @CD_ORC
				INSERT INTO TELE_ORC_ALERTA VALUES(@CD_ORC, 0)
			END
	
		-- REMOVE ALERTA
		DELETE 
		u
		FROM TELE_ORC_ALERTA u INNER JOIN INSERTED i ON
		     u.CD_ORC = i.CD_ORC AND (i.CD_ETAPAS = 5 OR i.CD_ETAPAS = 6 OR i.CD_ETAPAS = 10 OR i.CD_ETAPAS = 12)

		

		
		
			
	end try
	
	begin catch
		DECLARE @ErrorMessage NVARCHAR(4000);
		SELECT @ErrorMessage = ERROR_MESSAGE()
		RAISERROR ('Erro na trigger TRG_TELE_ORC_REMOVE_ALERTA. %s'  ,16, 1, @ErrorMessage); 
		RETURN;	
	end catch

end
GO


